<?php
include 'index.php';

if (isset($_POST['tambah'])) {
    // Ambil data dari form
    $id_obat = mysqli_real_escape_string($conn, $_POST['id_obat']);
    $periode = mysqli_real_escape_string($conn, $_POST['periode']);
    $demand_tahunan = floatval($_POST['demand_tahunan']);
    $biaya_pesan = floatval($_POST['biaya_pesan']);
    $biaya_simpan = floatval($_POST['biaya_simpan']);
    $lead_time = intval($_POST['lead_time']);
    $service_level = floatval($_POST['service_level']); // z-score
    $deviasi_demand = floatval($_POST['deviasi_demand']); // standar deviasi
    
    // Validasi input
    if (empty($id_obat) || empty($periode) || $demand_tahunan <= 0 || $biaya_pesan <= 0 || $biaya_simpan <= 0) {
        echo "<script>
                alert('Semua field harus diisi dengan benar!');
                window.location.href='eoq.php';
              </script>";
        exit();
    }
    
    // Cek apakah sudah ada EOQ untuk obat dan periode yang sama
    $cek_duplicate = mysqli_query($conn, "SELECT id_eoq FROM eoq WHERE id_obat = '$id_obat' AND periode = '$periode'");
    if (mysqli_num_rows($cek_duplicate) > 0) {
        echo "<script>
                alert('Perhitungan EOQ untuk obat ini pada periode $periode sudah ada!\\nSilakan edit data yang sudah ada atau pilih periode lain.');
                window.location.href='eoq.php';
              </script>";
        exit();
    }
    
    // Hitung EOQ
    // Rumus: EOQ = √((2 × D × S) / H)
    // D = Demand Tahunan
    // S = Biaya Pesan (Ordering Cost)
    // H = Biaya Simpan (Holding Cost)
    $eoq = sqrt((2 * $demand_tahunan * $biaya_pesan) / $biaya_simpan);
    $eoq = ceil($eoq); // Pembulatan ke atas
    
    // Hitung Safety Stock
    // Rumus: Safety Stock = z × σ × √L
    // z = service level (z-score)
    // σ = standar deviasi demand
    // L = lead time
    $safety_stock = $service_level * $deviasi_demand * sqrt($lead_time);
    $safety_stock = ceil($safety_stock); // Pembulatan ke atas
    
    // Hitung Reorder Point (ROP)
    // Rumus: ROP = (Demand Harian × Lead Time) + Safety Stock
    $demand_harian = $demand_tahunan / 365;
    $reorder_point = ($demand_harian * $lead_time) + $safety_stock;
    $reorder_point = ceil($reorder_point); // Pembulatan ke atas
    
    // Insert data ke database
    $query = "INSERT INTO eoq (
                id_obat, 
                periode, 
                demand_tahunan, 
                biaya_pesan, 
                biaya_simpan, 
                eoq, 
                safety_stock, 
                reorder_point
              ) VALUES (
                '$id_obat',
                '$periode',
                '$demand_tahunan',
                '$biaya_pesan',
                '$biaya_simpan',
                '$eoq',
                '$safety_stock',
                '$reorder_point'
              )";
    
    $result = mysqli_query($conn, $query);
    
    if ($result) {
        // Ambil nama obat untuk notifikasi
        $obat_query = mysqli_query($conn, "SELECT nama_obat FROM obat WHERE id_obat = '$id_obat'");
        $obat_data = mysqli_fetch_assoc($obat_query);
        $nama_obat = $obat_data['nama_obat'];
        
        // Hitung frekuensi pemesanan untuk informasi tambahan
        $frekuensi_pesan = ceil($demand_tahunan / $eoq);
        $interval_pesan = round(365 / $frekuensi_pesan);
        
        // INSERT NOTIFIKASI KE APOTEKER - VERSI RINGKAS
        $pesan_notifikasi = "Perhitungan EOQ selesai untuk periode $periode. EOQ: " . number_format($eoq, 0, ',', '.') . " unit | ROP: " . number_format($reorder_point, 0, ',', '.') . " unit | Pesan $frekuensi_pesan kali/tahun.";
        
        $pesan_notifikasi = mysqli_real_escape_string($conn, $pesan_notifikasi);
        
        $query_notif = "INSERT INTO notifikasi (
                            id_obat, 
                            kategori, 
                            pesan, 
                            status, 
                            role
                        ) VALUES (
                            '$id_obat',
                            'PEMESANAN_BARU',
                            '$pesan_notifikasi',
                            'BARU',
                            'apoteker'
                        )";
        
        mysqli_query($conn, $query_notif);
        
        echo "<script>
                alert('✅ Perhitungan EOQ berhasil disimpan!\\n\\n" .
                     "Obat: $nama_obat\\n" .
                     "Periode: $periode\\n" .
                     "━━━━━━━━━━━━━━━━━━━━━━\\n" .
                     "📊 EOQ: " . number_format($eoq, 0, ',', '.') . " unit\\n" .
                     "🛡️ Safety Stock: " . number_format($safety_stock, 0, ',', '.') . " unit\\n" .
                     "📍 Reorder Point: " . number_format($reorder_point, 0, ',', '.') . " unit\\n" .
                     "━━━━━━━━━━━━━━━━━━━━━━\\n" .
                     "💡 Rekomendasi:\\n" .
                     "• Pesan sebanyak " . number_format($eoq, 0, ',', '.') . " unit per order\\n" .
                     "• Pesan ulang saat stok ≤ " . number_format($reorder_point, 0, ',', '.') . " unit\\n" .
                     "• Frekuensi: $frekuensi_pesan kali/tahun (setiap ~$interval_pesan hari)\\n\\n" .
                     "📢 Notifikasi telah dikirim ke Apoteker');
                window.location.href='eoq.php';
              </script>";
    } else {
        echo "<script>
                alert('❌ Gagal menyimpan data EOQ!\\nError: " . mysqli_error($conn) . "');
                window.location.href='eoq.php';
              </script>";
    }
    
} else {
    // Jika akses langsung tanpa submit
    echo "<script>
            alert('⚠️ Akses tidak valid!');
            window.location.href='eoq.php';
          </script>";
}

mysqli_close($conn);
?>